/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.joml.Matrix4f;

public class SpriteRenderer {
    private final Matrix4f transform;
    private final VertexConsumer builder;
    private final int light;
    private final int z;
    private final int r;
    private final int g;
    private final int b;

    public SpriteRenderer(Matrix4f transform, VertexConsumer builder, int z, int light, int r, int g, int b) {
        this.transform = transform;
        this.builder = builder;
        this.z = z;
        this.light = light;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static SpriteRenderer createForGui(GuiGraphics graphics, RenderType renderType) {
        return new SpriteRenderer(graphics.pose().last().pose(), graphics.bufferSource().getBuffer(renderType), 0, 0xF000F0, 255, 255, 255);
    }

    public void blit(TextureAtlasSprite sprite, int x, int y, int width, int height) {
        this.blit(x, y, width, height, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1());
    }

    public void blitHorizontalSliced(TextureAtlasSprite sprite, int x, int y, int width, int height, int leftBorder, int rightBorder, int textureWidth) {
        if (width < leftBorder + rightBorder) {
            throw new IllegalArgumentException("width is less than two borders");
        }
        float centerStart = SpriteRenderer.u(sprite, leftBorder, textureWidth);
        float centerEnd = SpriteRenderer.u(sprite, textureWidth - rightBorder, textureWidth);
        this.blit(x, y, leftBorder, height, sprite.getU0(), sprite.getV0(), centerStart, sprite.getV1());
        this.blit(x + leftBorder, y, width - leftBorder - rightBorder, height, centerStart, sprite.getV0(), centerEnd, sprite.getV1());
        this.blit(x + width - rightBorder, y, rightBorder, height, centerEnd, sprite.getV0(), sprite.getU1(), sprite.getV1());
    }

    public void blitVerticalSliced(TextureAtlasSprite sprite, int x, int y, int width, int height, int topBorder, int bottomBorder, int textureHeight) {
        if (width < topBorder + bottomBorder) {
            throw new IllegalArgumentException("height is less than two borders");
        }
        float centerStart = SpriteRenderer.v(sprite, topBorder, textureHeight);
        float centerEnd = SpriteRenderer.v(sprite, textureHeight - bottomBorder, textureHeight);
        this.blit(x, y, width, topBorder, sprite.getU0(), sprite.getV0(), sprite.getU1(), centerStart);
        this.blit(x, y + topBorder, width, height - topBorder - bottomBorder, sprite.getU0(), centerStart, sprite.getU1(), centerEnd);
        this.blit(x, y + height - bottomBorder, width, bottomBorder, sprite.getU0(), centerEnd, sprite.getU1(), sprite.getV1());
    }

    public void blit(int x, int y, int width, int height, float u0, float v0, float u1, float v1) {
        this.builder.addVertex(this.transform, (float)x, (float)(y + height), (float)this.z).setColor(this.r, this.g, this.b, 255).setUv(u0, v1).setLight(this.light);
        this.builder.addVertex(this.transform, (float)(x + width), (float)(y + height), (float)this.z).setColor(this.r, this.g, this.b, 255).setUv(u1, v1).setLight(this.light);
        this.builder.addVertex(this.transform, (float)(x + width), (float)y, (float)this.z).setColor(this.r, this.g, this.b, 255).setUv(u1, v0).setLight(this.light);
        this.builder.addVertex(this.transform, (float)x, (float)y, (float)this.z).setColor(this.r, this.g, this.b, 255).setUv(u0, v0).setLight(this.light);
    }

    public static float u(TextureAtlasSprite sprite, int x, int width) {
        return sprite.getU((float)x / (float)width);
    }

    public static float v(TextureAtlasSprite sprite, int y, int height) {
        return sprite.getV((float)y / (float)height);
    }
}

