RecipeViewerEvents.addInformation('item', (event) => {
    // https://kubejs.com/wiki/events/RecipeViewerEvents/addInformation

    /* Format Codes
    Obfuscated      §k
    Bold            §l
    Strikethrough   §m
    Underline       §n
    Italic          §o
    Reset Format    §r

    Colors:
    Dark Red        §4
    Red             §c
    Gold            §6
    Yellow          §e
    Dark Green      §2
    Green           §a
    Aqua            §b
    Dark Aqua       §3
    Dark Blue       §1
    Blue            §9
    Light Purple    §d
    Dark Purple 	§5
    White           §f
    Gray            §7
    Dark Gray       §8
    Black           §0

    */
    const descriptions = [
        {
            filter: ['ae2:sky_dust'],
            text: ['Sky Dust can be generated by pointing an Annihilation Plane at the sky at build limit (§2Y=319§r).']
        },
        {
            filter: beheading_tools,
            text: ['Easily cleaves the heads from your foes!']
        },
        {
            filter: [
                'minecraft:zombie_head',
                'minecraft:creeper_head',
                'minecraft:piglin_head',
                'minecraft:dragon_head',
                'minecraft:skeleton_skull',
                'minecraft:wither_skeleton_skull',
                'enderio:enderman_head'
            ],
            text: [
                'Heads may be obtained from mobs by killing them with particularly powerful axes and paxels.',
                ' ',
                'Search for §5#beheading§r in EMI for a list!'
            ]
        },
        {
            filter: ['justdirethings:time_crystal'],
            text: [
                'Obtaining Time Crystals is a mult-step process across multiple dimensions.',
                ' ',
                Text.of(
                    'To begin, craft a Budding Time Crystal Block and place it in the Overworld; it will slowly charge up and turn a §1Blue§r color. Transfer it to The Nether where it will charge until it turns §6Orange§r, and finally to The End where it will charge until it turns §2Green§r.'
                ),
                ' ',
                'Once fully charged, the Budding Time Crystal Block will begin growing Time Crystal Clusters. Fully grown Clusters may be broken to obtain Time Crystals.',
                ' ',
                'Fully Charged Budding Time Crystal Blocks will slowly decay, at which point they must be transferred back to the Overworld to repeat the cycle.'
            ]
        },
        {
            filter: ['cursedearth:blessed_earth'],
            text: [
                'Rapidly spawns Passive mobs that would otherwise spawn in the area.',
                '',
                'Can spread to adjacent dirt blocks.'
            ]
        },
        {
            filter: ['cursedearth:cursed_earth'],
            text: [
                'Rapidly spawns Hostile mobs that would otherwise spawn in the area.',
                '',
                'Can spread to adjacent dirt blocks. Burns when exposed to daylight.'
            ]
        },
        {
            filter: ['enderio:industrial_insulation_block'],
            text: ['Absorbs and voids any fluids placed nearby.']
        },
        {
            filter: ['naturesaura:vacuum_bottle'],
            text: ['Use a Bottle and Cork in an area devoid of Aura.', ' ', `Can be automated using a Dispenser.`]
        },
        {
            filter: [Item.of('naturesaura:aura_bottle[naturesaura:aura_bottle_data={aura_type:"naturesaura:nether"}]')],
            text: [
                'Use a Bottle and Cork in an area of high Aura in the Nether.',
                ' ',
                `Can be automated using a Dispenser.`
            ]
        },
        {
            filter: [
                Item.of('naturesaura:aura_bottle[naturesaura:aura_bottle_data={aura_type:"naturesaura:overworld"}]')
            ],
            text: [
                'Use a Bottle and Cork in an area of high Aura in the Overworld.',
                ' ',
                `Can be automated using a Dispenser.`
            ]
        },
        {
            filter: [Item.of('naturesaura:aura_bottle[naturesaura:aura_bottle_data={aura_type:"naturesaura:end"}]')],
            text: [
                'Use a Bottle and Cork in an area of high Aura in the End.',
                ' ',
                `Can be automated using a Dispenser.`
            ]
        },
        {
            filter: ['naturesaura:gold_leaf'],
            text: [`Obtained by breaking Golden Leaves.`]
        },
        {
            filter: ['naturesaura:golden_leaves'],
            text: [`Obtained by using Brilliant Fiber on leaves. Allow to spread for best effect.`]
        },
        {
            filter: ['naturesaura:break_prevention'],
            text: [
                `When applied to a tool in an anvil, the tool will stop working when durability runs out instead of being destroyed.`
            ]
        },
        {
            filter: ['naturesaura:birth_spirit'],
            text: [`Obtained by manually breeding animals in high Aura areas.`]
        },
        {
            filter: ['naturesaura:projectile_generator'],
            text: [
                `Valid projectiles from least to most potent.`,
                ` `,
                `● Snowball`,
                `● Egg`,
                `● Arrow`,
                `● Fire Charge`,
                `● Spectral Arrow`,
                `● Ender Pearl`,
                `● Llama Spit`,
                `● Bottle o' Enchanting`,
                `● Shulker Bullet`,
                `● Trident`
            ]
        },
        {
            filter: [Ingredient.of('#malum:soul_shatter_capable_weapons')],
            text: [`Capable of obtaining Malum Spirits.`]
        },
        {
            filter: ['malum:rotting_essence'],
            text: [`Occasionally dropped by Zombies slain with a Soul Shattering Weapon.`]
        },
        {
            filter: ['malum:grim_talc'],
            text: [`Occasionally dropped by Skeletons slain with a Soul Shattering Weapon.`]
        },
        {
            filter: ['malum:astral_weave'],
            text: [`Occasionally dropped by Phantoms slain with a Soul Shattering Weapon.`]
        },
        {
            filter: ['malum:wind_nucleus'],
            text: [`Occasionally dropped by Breeze slain with a Soul Shattering Weapon.`]
        },
        {
            filter: ['malum:warp_flux'],
            text: [`Occasionally dropped by Endermen slain with a Soul Shattering Weapon.`]
        },
        {
            filter: ['immersiveengineering:blueprint[immersiveengineering:blueprint="automatons"]'],
            text: [`Can be found in Trial Chambers.`]
        },
        {
            filter: ['immersiveengineering:blueprint[immersiveengineering:blueprint="specialBullet"]'],
            text: [`Can be purchased from a Gunsmith Villager.`]
        }
    ];

    descriptions.forEach((description) => {
        event.add(description.filter, description.text);
    });
});
