ServerEvents.generateData('after_mods', (event) => {
    // Match blocks by Blockstate: https://klikli-dev.github.io/modonomicon/docs/multiblocks/state-matchers/blockstate-matcher/
    // A: {
    //     type: 'modonomicon:blockstate',
    //     display: 'minecraft:chest[facing=east]',
    //     block: 'minecraft:chest[facing=west]'
    // }
    // Match blocks by Tag: https://klikli-dev.github.io/modonomicon/docs/multiblocks/state-matchers/tag-matcher/
    // A: {
    //     type: 'modonomicon:tag',
    //     tag: 'minecraft:planks'
    // }

    const default_mapping = {
        0: {
            type: 'modonomicon:tag',
            display: 'occultism:golden_sacrificial_bowl',
            tag: '#occultism:center_sacrificial_bowl'
        },
        W: {
            type: 'modonomicon:tag',
            tag: '#occultism:foundation_glyphs_any',
            display: 'occultism:chalk_glyph_white'
        },
        Y: {
            type: 'modonomicon:tag',
            display: 'occultism:chalk_glyph_gold',
            tag: '#occultism:glyphs_yellow'
        },
        P: {
            type: 'modonomicon:tag',
            display: 'occultism:chalk_glyph_purple',
            tag: '#occultism:glyphs_purple'
        },
        R: {
            type: 'modonomicon:tag',
            display: 'occultism:chalk_glyph_red',
            tag: '#occultism:glyphs_red'
        },
        B: {
            type: 'modonomicon:tag',
            display: 'occultism:chalk_glyph_blue',
            tag: '#occultism:glyphs_blue'
        },
        1: {
            type: 'modonomicon:tag',
            display: 'occultism:large_candle',
            tag: '#minecraft:candles'
        },
        C: {
            type: 'modonomicon:block',
            block: 'occultism:spirit_attuned_crystal'
        },
        O: {
            type: 'modonomicon:block',
            block: 'occultism:otherstone'
        },
        L: {
            type: 'modonomicon:block',
            block: 'minecraft:sea_lantern'
        },
        6: { type: 'modonomicon:block', block: 'minecraft:sculk' },
        7: { type: 'modonomicon:block', block: 'minecraft:sculk_shrieker' },
        8: { type: 'modonomicon:block', block: 'minecraft:sculk_sensor' }
    };

    const tier_1_mapping = {
        F: {
            type: 'modonomicon:tag',
            display: 'minecraft:tuff_bricks',
            tag: '#occultism:bricks/tier_1'
        },
        A: {
            type: 'modonomicon:tag',
            display: 'minecraft:chiseled_tuff',
            tag: '#occultism:accents/tier_1'
        },
        M: {
            type: 'modonomicon:tag',
            display: 'minecraft:copper_block',
            tag: '#occultism:moderators/tier_1'
        }
    };
    const tier_2_mapping = {
        F: {
            type: 'modonomicon:tag',
            display: 'minecraft:tuff_bricks',
            tag: '#occultism:bricks/tier_2'
        },
        A: {
            type: 'modonomicon:tag',
            display: 'minecraft:chiseled_tuff',
            tag: '#occultism:accents/tier_2'
        },
        S: {
            type: 'modonomicon:tag',
            display: 'minecraft:skeleton_skull',
            tag: '#occultism:skulls/tier_2'
        },
        M: {
            type: 'modonomicon:tag',
            display: 'minecraft:gold_block',
            tag: '#occultism:moderators/tier_2'
        }
    };
    const tier_2_5_mapping = {
        F: {
            type: 'modonomicon:tag',
            display: 'minecraft:red_nether_bricks',
            tag: '#occultism:bricks/tier_3'
        },
        A: {
            type: 'modonomicon:tag',
            display: 'minecraft:chiseled_nether_bricks',
            tag: '#occultism:accents/tier_3'
        },
        S: {
            type: 'modonomicon:tag',
            display: 'minecraft:skeleton_skull',
            tag: '#occultism:skulls/tier_2'
        },
        M: {
            type: 'modonomicon:tag',
            display: 'occultism:iesnium_block',
            tag: '#occultism:moderators/tier_3'
        }
    };
    const tier_3_mapping = {
        F: {
            type: 'modonomicon:tag',
            display: 'minecraft:red_nether_bricks',
            tag: '#occultism:bricks/tier_3'
        },
        A: {
            type: 'modonomicon:tag',
            display: 'minecraft:chiseled_nether_bricks',
            tag: '#occultism:accents/tier_3'
        },
        S: {
            type: 'modonomicon:tag',
            display: 'minecraft:wither_skeleton_skull',
            tag: '#occultism:skulls/tier_3'
        },
        M: {
            type: 'modonomicon:tag',
            display: 'occultism:iesnium_block',
            tag: '#occultism:moderators/tier_3'
        }
    };
    const tier_3_5_mapping = {
        F: {
            type: 'modonomicon:tag',
            display: 'minecraft:prismarine_bricks',
            tag: '#occultism:bricks/tier_4'
        },
        A: {
            type: 'modonomicon:tag',
            display: 'minecraft:dark_prismarine',
            tag: '#occultism:accents/tier_4'
        },
        S: {
            type: 'modonomicon:tag',
            display: 'minecraft:wither_skeleton_skull',
            tag: '#occultism:skulls/tier_3'
        },
        M: {
            type: 'modonomicon:tag',
            display: 'occultism:iesnium_block',
            tag: '#occultism:moderators/tier_4'
        }
    };
    const tier_4_mapping = {
        F: {
            type: 'modonomicon:tag',
            display: 'minecraft:prismarine_bricks',
            tag: '#occultism:bricks/tier_4'
        },
        A: {
            type: 'modonomicon:tag',
            display: 'minecraft:dark_prismarine',
            tag: '#occultism:accents/tier_4'
        },
        S: {
            type: 'modonomicon:tag',
            display: 'minecraft:conduit[waterlogged=false]',
            tag: '#occultism:skulls/tier_4'
        },
        M: {
            type: 'modonomicon:tag',
            display: 'occultism:iesnium_block',
            tag: '#occultism:moderators/tier_4'
        }
    };

    let pentacles = [
        // Summoning Pentacle Overrides
        {
            name: 'summon_foliot',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_1_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______M_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______F_______',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______M_______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______M_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '____1_WOW_1____',
                    '_____W_F_W_____',
                    '____W_____W____',
                    '____W__0__W____',
                    '____W_____W____',
                    '_____W_F_W_____',
                    '____1_WOW_1____',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ]
            ]
        },
        {
            name: 'summon_djinni',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_2_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______M_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______F_______',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______M_______',
                    '______SFS______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '______SFS______',
                    '_______M_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '___YY_____YY___',
                    '_____Y___Y_____',
                    '____1YWOWY1____',
                    '_____WAFAW_____',
                    '____W_____W____',
                    '____W__0__W____',
                    '____W_____W____',
                    '_____WAFAW_____',
                    '____1YWOWY1____',
                    '_____Y___Y_____',
                    '___YY_____YY___',
                    '_______________',
                    '_______________'
                ]
            ]
        },
        {
            name: 'summon_unbound_afrit',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_2_5_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______M_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______F_______',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______M_______',
                    '______SFS______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '______SFS______',
                    '_______M_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '___YY_____YY___',
                    '___C_Y___Y_C___',
                    '____1YWOWY1____',
                    '_____WAFAW_____',
                    '____W_____W____',
                    '____W__0__W____',
                    '____W_____W____',
                    '_____WAFAW_____',
                    '____1YWOWY1____',
                    '___C_Y___Y_C___',
                    '___YY_____YY___',
                    '_______________',
                    '_______________'
                ]
            ]
        },
        {
            name: 'summon_afrit',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_3_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______M_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______F_______',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______M_______',
                    '______SFS______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '______SFS______',
                    '_______M_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '___RRR___RRR___',
                    '__RYY_R_R_YYR__',
                    '_R_C_YR_RY_C_R_',
                    '_R__1YWOWY1__R_',
                    '__R__WAFAW__R__',
                    '____W_____W____',
                    '____W__0__W____',
                    '____W_____W____',
                    '__R__WAFAW__R__',
                    '_R__1YWOWY1__R_',
                    '_R_C_YR_RY_C_R_',
                    '__RYY_R_R_YYR__',
                    '___RRR___RRR___',
                    '_______________'
                ]
            ]
        },
        {
            name: 'summon_unbound_marid',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_3_5_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______M_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______F_______',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '_______O_______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______O_______',
                    '____F_____F____',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '____L_____L____',
                    '_______M_______',
                    '______SFS______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '______SFS______',
                    '_______M_______',
                    '____L_____L____',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '___RRR___RRR___',
                    '__RYY_R_R_YYR__',
                    '_R_CFYR_RYFC_R_',
                    '_R__1YWOWY1__R_',
                    '__R__WAFAW__R__',
                    '____W_____W____',
                    '____W__0__W____',
                    '____W_____W____',
                    '__R__WAFAW__R__',
                    '_R__1YWOWY1__R_',
                    '_R_CFYR_RYFC_R_',
                    '__RYY_R_R_YYR__',
                    '___RRR___RRR___',
                    '_______________'
                ]
            ]
        },
        {
            name: 'summon_marid',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_4_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______M_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______O_______',
                    '_______F_______',
                    '_______F_______',
                    '_______F_______',
                    '_______O_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '_______O_______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______O_______',
                    '____F_____F____',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '____L_____L____',
                    '_______M_______',
                    '______SFS______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '______SFS______',
                    '_______M_______',
                    '____L_____L____',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '___BBB___BBB___',
                    '__BYY_B_B_YYB__',
                    '_B_CFYB_BYFC_B_',
                    '_B__1YWOWY1__B_',
                    '__B__WAFAW__B__',
                    '____W_____W____',
                    '____W__0__W____',
                    '____W_____W____',
                    '__B__WAFAW__B__',
                    '_B__1YWOWY1__B_',
                    '_B_CFYB_BYFC_B_',
                    '__BYY_B_B_YYB__',
                    '___BBB___BBB___',
                    '_______________'
                ]
            ]
        },
        // Possession Pentacle Overrides
        {
            name: 'possess_foliot',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_1_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___F_______F___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___F_______F___',
                    '____F_____F____',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___O_______O___',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '___O_______O___',
                    '____F_____F____',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '____O_____O____',
                    '___M_______M___',
                    '__O_________O__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__O_________O__',
                    '___M_______M___',
                    '____O_____O____',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '____F1_Y_1F____',
                    '___O__Y_Y__O___',
                    '__F__Y___Y__F__',
                    '__1_Y_____Y_1__',
                    '___Y_______Y___',
                    '__Y____0____Y__',
                    '___Y_______Y___',
                    '__1_Y_____Y_1__',
                    '__F__Y___Y__F__',
                    '___O__Y_Y__O___',
                    '____F1_Y_1F____',
                    '_______________',
                    '_______________'
                ]
            ]
        },
        {
            name: 'possess_djinni',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_2_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___F_______F___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___F_______F___',
                    '____F_____F____',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___O_______O___',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '___O_______O___',
                    '____F_____F____',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______S_______',
                    '_______________',
                    '____O_____O____',
                    '___M_______M___',
                    '__O_________O__',
                    '_______________',
                    '_______________',
                    'S_____________S',
                    '_______________',
                    '_______________',
                    '__O_________O__',
                    '___M_______M___',
                    '____O_____O____',
                    '_______________',
                    '_______S_______'
                ],
                [
                    '_______A_______',
                    '_______________',
                    '____F1_Y_1F____',
                    '___O__Y_Y__O___',
                    '__F__Y___Y__F__',
                    '__1_Y_____Y_1__',
                    '___Y_______Y___',
                    'A_Y____0____Y_A',
                    '___Y_______Y___',
                    '__1_Y_____Y_1__',
                    '__F__Y___Y__F__',
                    '___O__Y_Y__O___',
                    '____F1_Y_1F____',
                    '_______________',
                    '_______A_______'
                ]
            ]
        },
        {
            name: 'possess_unbound_afrit',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_2_5_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___F_______F___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___F_______F___',
                    '____F_____F____',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___O_______O___',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '___O_______O___',
                    '____F_____F____',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______S_______',
                    '_______________',
                    '____O_____O____',
                    '___M_______M___',
                    '__O_________O__',
                    '_______________',
                    '_______________',
                    'S_____________S',
                    '_______________',
                    '_______________',
                    '__O_________O__',
                    '___M_______M___',
                    '____O_____O____',
                    '_______________',
                    '_______S_______'
                ],
                [
                    '_______A_______',
                    '_______________',
                    '____F1_Y_1F____',
                    '___O__Y_Y__O___',
                    '__F_CY___YC_F__',
                    '__1_YP___PY_1__',
                    '___Y__P_P__Y___',
                    'A_Y____0____Y_A',
                    '___Y__P_P__Y___',
                    '__1_YP___PY_1__',
                    '__F_CY___YC_F__',
                    '___O__Y_Y__O___',
                    '____F1_Y_1F____',
                    '_______________',
                    '_______A_______'
                ]
            ]
        },
        {
            name: 'possess_afrit',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_3_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___F_______F___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___F_______F___',
                    '____F_____F____',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___O_______O___',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '___O_______O___',
                    '____F_____F____',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______S_______',
                    '_______________',
                    '____O_____O____',
                    '___M_______M___',
                    '__O_________O__',
                    '_______________',
                    '_______________',
                    'S_____________S',
                    '_______________',
                    '_______________',
                    '__O_________O__',
                    '___M_______M___',
                    '____O_____O____',
                    '_______________',
                    '_______S_______'
                ],
                [
                    '______RAR______',
                    '_____R___R_____',
                    '____F1_Y_1F____',
                    '___O__Y_Y__O___',
                    '__F_CY___YC_F__',
                    '_R1_YP___PY_1R_',
                    'R__Y__P_P__Y__R',
                    'A_Y____0____Y_A',
                    'R__Y__P_P__Y__R',
                    '_R1_YP___PY_1R_',
                    '__F_CY___YC_F__',
                    '___O__Y_Y__O___',
                    '____F1_Y_1F____',
                    '_____R___R_____',
                    '______RAR______'
                ]
            ]
        },
        {
            name: 'possess_marid',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_4_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___F_______F___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___F_______F___',
                    '____F_____F____',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '____F_____F____',
                    '___O_______O___',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '___O_______O___',
                    '____F_____F____',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______S_______',
                    '_______________',
                    '____O_____O____',
                    '___M_______M___',
                    '__O_________O__',
                    '_______________',
                    '_______________',
                    'S_____________S',
                    '_______________',
                    '_______________',
                    '__O_________O__',
                    '___M_______M___',
                    '____O_____O____',
                    '_______________',
                    '_______S_______'
                ],
                [
                    '______BAB______',
                    '_____B___B_____',
                    '____F1_Y_1F____',
                    '___O__Y_Y__O___',
                    '__F_CY___YC_F__',
                    '_B1_YP___PY_1B_',
                    'B__Y__P_P__Y__B',
                    'A_Y____0____Y_A',
                    'B__Y__P_P__Y__B',
                    '_B1_YP___PY_1B_',
                    '__F_CY___YC_F__',
                    '___O__Y_Y__O___',
                    '____F1_Y_1F____',
                    '_____B___B_____',
                    '______BAB______'
                ]
            ]
        },

        // Infusion Pentacle Overrides
        {
            name: 'craft_foliot',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_1_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '______FOF______',
                    '_____FOOOF_____',
                    '____FOOMOOF____',
                    '_____FOOOF_____',
                    '______FOF______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___F_______F___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '______FFF______',
                    '_______________',
                    '____1PPPPP1____',
                    '____P_____P____',
                    '__F_P_____P_F__',
                    '__F_P__0__P_F__',
                    '__F_P_____P_F__',
                    '____P_____P____',
                    '____1PPPPP1____',
                    '_______________',
                    '______FFF______',
                    '_______________',
                    '_______________'
                ]
            ]
        },
        {
            name: 'craft_djinni',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_2_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '______FOF______',
                    '_____FOOOF_____',
                    '____FOOMOOF____',
                    '_____FOOOF_____',
                    '______FOF______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___F_______F___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '___S_______S___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___S_______S___',
                    '_______F_______',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '______FFF______',
                    '___A_______A___',
                    '____1PPPPP1____',
                    '____P_____P____',
                    '__F_P_____P_F__',
                    '__F_P__0__P_F__',
                    '__F_P_____P_F__',
                    '____P_____P____',
                    '____1PPPPP1____',
                    '___A_______A___',
                    '______FFF______',
                    '_______________',
                    '_______________'
                ]
            ]
        },
        {
            name: 'craft_afrit',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_3_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '______FOF______',
                    '_____FOOOF_____',
                    '____FOOMOOF____',
                    '_____FOOOF_____',
                    '______FOF______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___F_______F___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '___S_______S___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___S_______S___',
                    '_______F_______',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '______FFF______',
                    '___ARRRCRRRA___',
                    '___R1PPPPP1R___',
                    '___RP_____PR___',
                    '__FRP_____PRF__',
                    '__FCP__0__PCF__',
                    '__FRP_____PRF__',
                    '___RP_____PR___',
                    '___R1PPPPP1R___',
                    '___ARRRCRRRA___',
                    '______FFF______',
                    '_______________',
                    '_______________'
                ]
            ]
        },
        {
            name: 'craft_marid',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_4_mapping),
            pattern: [
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '______FOF______',
                    '_____FOOOF_____',
                    '____FOOMOOF____',
                    '_____FOOOF_____',
                    '______FOF______',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___F_______F___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________'
                ],
                [
                    '_______________',
                    '_F___________F_',
                    '_______F_______',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______________',
                    '_______F_______',
                    '_F___________F_',
                    '_______________'
                ],
                [
                    '_______________',
                    '_L___________L_',
                    '_______F_______',
                    '___S_______S___',
                    '_______________',
                    '_______________',
                    '_______________',
                    '__F_________F__',
                    '_______________',
                    '_______________',
                    '_______________',
                    '___S_______S___',
                    '_______F_______',
                    '_L___________L_',
                    '_______________'
                ],
                [
                    '_______________',
                    '_F___________F_',
                    '__BBB_FFF_BBB__',
                    '__BABBBCBBBAB__',
                    '__BB1PPPPP1BB__',
                    '___BP_____PB___',
                    '__FBP_____PBF__',
                    '__FCP__0__PCF__',
                    '__FBP_____PBF__',
                    '___BP_____PB___',
                    '__BB1PPPPP1BB__',
                    '__BABBBCBBBAB__',
                    '__BBB_FFF_BBB__',
                    '_F___________F_',
                    '_______________'
                ]
            ]
        },

        // Wild Pentacle Overrides
        {
            name: 'resurrect_spirit',
            override: true,
            mapping: default_mapping,
            pattern: [
                [
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '________WWW________',
                    '_______W___W_______',
                    '______W_____W______',
                    '______W__0__W______',
                    '______W_____W______',
                    '_______W___W_______',
                    '________WWW________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________'
                ]
            ]
        },
        {
            name: 'contact_wild_spirit',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_3_mapping),
            pattern: [
                [
                    '___________________',
                    '__F_____________F__',
                    '_F_______________F_',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '_F_______________F_',
                    '__F_____________F__',
                    '___________________'
                ],
                [
                    '__F_____________F__',
                    '_O_______________O_',
                    'F_________________F',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    'F_________________F',
                    '_O_______________O_',
                    '__F_____________F__'
                ],
                [
                    '__O_____________O__',
                    '_M_______________M_',
                    'O_________________O',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    'O_________________O',
                    '_M_______________M_',
                    '__O_____________O__'
                ],
                [
                    '__FR___________RF__',
                    '_O__R_________R__O_',
                    'F___R_________R___F',
                    'R____R__RPR__R____R',
                    '_RR___RRPWPRR___RR_',
                    '___R_W_YRPRY_W_R___',
                    '____R_Y_WWW_Y_R____',
                    '____RY_W___W_YR____',
                    '___RPRW_____WRPR___',
                    '___PWPW__0__WPWP___',
                    '___RPRW_____WRPR___',
                    '____RY_W___W_YR____',
                    '____R_Y_WWW_Y_R____',
                    '___R_W_YRPRY_W_R___',
                    '_RR___RRPWPRR___RR_',
                    'R____R__RPR__R____R',
                    'F___R_________R___F',
                    '_O__R_________R__O_',
                    '__FR___________RF__'
                ]
            ]
        },
        {
            name: 'contact_eldritch_spirit',
            override: true,
            mapping: Object.assign({}, default_mapping, tier_4_mapping),
            pattern: [
                [
                    '___________________',
                    '___________________',
                    '___________________',
                    '_________6_________',
                    '_________6_________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___66_________66___',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___________________',
                    '_________6_________',
                    '_________6_________',
                    '___________________',
                    '___________________',
                    '___________________'
                ],
                [
                    '___________________',
                    '__F_____________F__',
                    '_F_______6_______F_',
                    '________6_6________',
                    '____7_________7____',
                    '___________________',
                    '___________________',
                    '___________________',
                    '___6___________6___',
                    '__6_____________6__',
                    '___6___________6___',
                    '___________________',
                    '___________________',
                    '___________________',
                    '____7_________7____',
                    '________6_6________',
                    '_F_______6_______F_',
                    '__F_____________F__',
                    '___________________'
                ],
                [
                    '__F_____________F__',
                    '_O_______6_______O_',
                    'F_______6_6_______F',
                    '___________________',
                    '____6_________6____',
                    '___________________',
                    '___________________',
                    '___________________',
                    '__6_____________6__',
                    '_6_______________6_',
                    '__6_____________6__',
                    '___________________',
                    '___________________',
                    '___________________',
                    '____6_________6____',
                    '___________________',
                    'F_______6_6_______F',
                    '_O_______6_______O_',
                    '__F_____________F__'
                ],
                [
                    '__O_____________O__',
                    '_M_______6_______M_',
                    'O_____8_6_6_8_____O',
                    '___________________',
                    '____6_________6____',
                    '___________________',
                    '__8_____________8__',
                    '___________________',
                    '__6_____________6__',
                    '_6_______________6_',
                    '__6_____________6__',
                    '___________________',
                    '__8_____________8__',
                    '___________________',
                    '____6_________6____',
                    '___________________',
                    'O_____8_6_6_8_____O',
                    '_M_______6_______M_',
                    '__O_____________O__'
                ],
                [
                    '__FB___________BF__',
                    '_O__B____6____B__O_',
                    'F___B_6_6_6_6_B___F',
                    'B____B__BPB__B____B',
                    '_BB_6_BBPWPBB_6_BB_',
                    '___B_W_YBPBY_W_B___',
                    '__6_B_Y_WWW_Y_B_6__',
                    '____BY_W___W_YB____',
                    '__6BPBW_____WBPB6__',
                    '_6_PWPW__0__WPWP_6_',
                    '__6BPBW_____WBPB6__',
                    '____BY_W___W_YB____',
                    '__6_B_Y_WWW_Y_B_6__',
                    '___B_W_YBPBY_W_B___',
                    '_BB_6_BBPWPBB_6_BB_',
                    'B____B__BPB__B____B',
                    'F___B_6_6_6_6_B___F',
                    '_O__B____6____B__O_',
                    '__FB___________BF__'
                ]
            ]
        }
    ];

    pentacles.forEach((pentacle) => {
        pentacle.type = 'modonomicon:dense';

        // Set background display. Same size as pentacle, blocks alternate between otherstone and andesite.
        // * and + are used as the keys following Occultism's convention.
        let ground = [];
        let pattern = pentacle.pattern[0];

        for (let i = 0; i < pattern.length; i++) {
            let row = '';
            for (let j = 0; j < pattern[i].length; j++) {
                row += (i + j) % 2 == 0 ? '*' : '+';
            }
            ground.push(row);
        }

        pentacle.pattern.push(ground);
        pentacle.mapping['*'] = { type: 'modonomicon:display', display: 'occultism:otherstone' };
        pentacle.mapping['+'] = { type: 'modonomicon:display', display: 'minecraft:stone' };

        event.json(`occultism:modonomicon/multiblocks/${pentacle.name}`, pentacle);

        // Remember to set lang entries for all new pentacles in en_us.json
        // x and y placement refer to the entry location within the modonomicon
        if (!pentacle.override) {
            {
                event.json(
                    `occultism:modonomicon/books/dictionary_of_spirits/entries/pentacles/${pentacle.name}`,
                    generatePentacleEntry(pentacle.name, pentacle.x_placement, pentacle.y_placement, pentacle.parents)
                );
            }
        }
    });
});
